﻿param(
    [switch]$Force
)

# Check if the execution policy needs to be changed
$executionPolicy = Get-ExecutionPolicy
if ($executionPolicy -ne 'Unrestricted') {
    if ($Force -or (Read-Host "The script requires Unrestricted execution policy. Do you want to change the execution policy? (Y/N)" -eq 'Y')) {
        Start-Process powershell -ArgumentList "Set-ExecutionPolicy -ExecutionPolicy Unrestricted -Scope Process -Force" -Verb RunAs
    } else {
        Write-Host "Execution policy not changed. Exiting script."
        Exit
    }
}